<?php

namespace Vtlabs\Cardgame\Jobs\Poker;

use Illuminate\Support\Arr;
use Illuminate\Bus\Queueable;
use Vtlabs\Cardgame\Models\Poker;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Vtlabs\Core\Services\FirebaseService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class StartPoker implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $pokerId;

    public function __construct($pokerId)
    {
        $this->pokerId = $pokerId;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try {
            $poker = Poker::find($this->pokerId);
            
            $cards = Arr::shuffle(explode(',', $poker->cards));

            // assign position to players and distribute cards, position is assigned on first come basis, i.e. first player to join gets 1st position
            foreach ($poker->pokerplayers as $index => $player) {
                $player->cards = implode(',', array_splice($cards, 0, 2));
                $player->position = $index+1;
                $player->status = 'active';
                $player->save();
            }
            
            $poker->community_cards = implode(',', array_splice($cards, 0, 5));
            // if there are two player the player_turn=2 i.e big blind of the game, if more than two player then player_turn=3 i.e next of big blind
            $poker->player_turn = $poker->pokerplayers->count() == 2 ? 2 : 3;

            // pot value
            $poker->pot_value = $poker->pokerplayers[0]->turn_amount + $poker->pokerplayers[1]->turn_amount; // initially pot value will be sum of small blind joining_value + big blind joining value(small blind joining value *2 )

            $poker->cards = implode(',', $cards);
            $poker->status = 'preflop';

            $poker->save();
            $poker = $poker->fresh();

            $firebaseDatabase = FirebaseService::getDatabaseInstance();
            if ($firebaseDatabase) {
                $firebaseDatabase->getReference('/fire_app/poker/' . $poker->id)->set($poker);
            }
        } catch (\Exception $ex) {
            //
        }
    }
}
