<?php

namespace Vtlabs\Cardgame\Jobs;

use Illuminate\Support\Arr;
use Illuminate\Bus\Queueable;
use Vtlabs\Cardgame\Models\Game;
use Illuminate\Support\Facades\Log;
use Vtlabs\Cardgame\Jobs\TurnSetup;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Vtlabs\Core\Services\FirebaseService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class PlayerSetup implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $gameId;

    public function __construct($gameId)
    {
        $this->gameId = $gameId;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try {
            $game = Game::find($this->gameId);

            $cards = Arr::shuffle(explode(',', $game->cards));

            foreach ($game->gamePlayers as $index => $gamePlayer) {
                $gamePlayer->cards = implode(',', array_splice($cards, 0, 13));
                $gamePlayer->status = 'active';
                $gamePlayer->empty_turns = 0;
                $gamePlayer->points = 80; // initialize points to 80 for all players in the begining
                $gamePlayer->save();
            }

            $wildCard = array_shift($cards);
            $openCard = array_shift($cards);

            $game->wildcard = $wildCard;
            $game->open_cards = $openCard;
            $game->cards = implode(',', $cards);
            $game->status = 'cards_spread';

            $game->save();

            $game = $game->fresh();

            $firebaseDatabase = FirebaseService::getDatabaseInstance();
            if ($firebaseDatabase) {
                $firebaseDatabase->getReference('/fire_app/games/' . $game->id)->set($game);
            }

            // run next job which will do the turn setup
            $settings = CoreHelper::settingsAsDictionary();
            TurnSetup::dispatch($game->id)->delay(now()->addSeconds($settings['turn_setup_in_seconds']));
            
        } catch (\Exception $ex) {
            Log::error($ex->getMessage());
        }
    }
}
