<?php

namespace Vtlabs\Cardgame\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'details' => $this->title,
            'details_translations' => $this->getTranslations('details'),
            'type' => $this->type,
            'price' => $this->price,
            'quantity' => $this->quantity,
            'currency_type' => $this->currency_type,
            'mediaurls' => $this->getMediaUrlsAttribute(),
            'meta' => $this->meta,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
