<?php

namespace Vtlabs\Cardgame\Http\Resources;

use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Payment\Http\Resources\PaymentResource;
use Vtlabs\Cardgame\Http\Resources\ProductResource;

class OrderResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'subtotal' => $this->subtotal,
            'taxes' => $this->taxes,
            'discount' => $this->discount,
            'total' => $this->total,
            'product' => new ProductResource($this->product),
            'product_id' => $this->product_id,
            'user' => new UserResource($this->user),
            'user_id' => $this->user_id,
            'payment' => new PaymentResource($this->payment),
            'meta' => $this->meta,
            'status' => $this->status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
