<?php

namespace Vtlabs\Cardgame\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Cardgame\Http\Resources\RewardResource;

class LevelResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'condition_type' => $this->condition_type,
            'condition_count' => $this->condition_count,
            'sort_order' => $this->sort_order,
            'mediaurls' => $this->getMediaUrlsAttribute(),
            'parent_id' => $this->parent_id,
            'parent' => new LevelResource($this->parent),
            'rewards' => RewardResource::collection($this->rewards),
            'meta' => $this->meta,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
