<?php

namespace Vtlabs\Cardgame\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ChallengeResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'details' => $this->title,
            'details_translations' => $this->getTranslations('details'),
            'tasks_count' => $this->tasks_count,
            'type' => $this->type,
            'action' => $this->action,
            'sort_order' => $this->sort_order,
            'meta' => $this->meta,
            'rewards' => RewardResource::collection($this->rewards),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
