<?php

namespace Vtlabs\Cardgame\Http\Resources;

use Vtlabs\Cardgame\Models\Game;
use Illuminate\Http\Resources\Json\JsonResource;

class CashtableResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'reward' => $this->reward,
            'amount' => $this->amount,
            'meta' => $this->meta,
            'players_playing_count' => Game::activePlayersByCashtableCount($this->id),
        ];
    }
}
