<?php

namespace Vtlabs\Cardgame\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Core\Models\User\User;
use Illuminate\Support\Facades\DB;
use Vtlabs\Cardgame\Models\Profile;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Cardgame\Http\Resources\ProfileResource;
use Vtlabs\Cardgame\Http\Resources\LeaderboardResource;

class ProfileController extends Controller
{
    public function showMyProfile(Request $request)
    {
        return new ProfileResource(Profile::findByUser(Auth::id()));
    }

    public function referral(Request $request) 
    {
        $request->validate([
            'referral_code' => 'required'
        ]);

        $user = User::where('referral_code', $request->referral_code)->firstOrFail();

        // @TODO: apply referral logic e.g credit chip to users on succesful referral

        return response()->json((object)[]);
    }

    public function leaderboard(Request $request)
    {
        $leaderboard = Profile::leaderboard();

        return LeaderboardResource::collection($leaderboard);
    }

    public function walletStats()
    {
        $user = Auth::user();

        return response()->json([
            'balance' => $user->balance,
            'total_deposited' => $user->transactions()->where('meta->type', 'deposit')->sum('amount'),
            'total_won' => $user->transactions()->where('meta->type', 'earnings')->sum('amount'),
            'total_lost' => $user->transactions()->where('meta->type', 'loss')->sum('amount')
        ]);
    }
}
