<?php

namespace Vtlabs\Cardgame\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Cardgame\Models\Poker;
use Vtlabs\Cardgame\Models\Profile;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Cardgame\Models\Pokerplayer;
use Vtlabs\Core\Services\FirebaseService;
use Vtlabs\Core\Http\Controllers\Controller;

class PokerController extends Controller
{
    public function findGame(Request $request)
    {
        $request->validate([
            'turn_amount' => 'required|numeric',
            'joining_balance' => 'required|numeric'
        ]);

        $profile = Profile::findByUser(Auth::id());

        $poker = Poker::findPoker($profile, $request->turn_amount, $request->joining_balance);

        return response()->json($poker);
    }

    public function playTurn(Poker $poker, Pokerplayer $pokerPlayer, Request $request)
    {
        $request->validate([
            'action' => 'required|in:call,raise,fold,check,allin',
            'amount' => 'sometimes',
            'raise_amount' => 'sometimes'
        ]);

        $action = $request->action;
        $amount = $requst->amount ?? 0;
        $raiseAmount = $request->raise_amount ?? 0;

        // add any $raiseAmount in poker's pot_value
        if ($raiseAmount > 0) {
            if ($action == 'allin') {
                // ask aman what will happen in else case of this
                if ($raiseAmount > $poker->max_turn_amount) {
                    $poker->max_turn_amount = $raiseAmount;
                }
            } else {
                $poker->max_turn_amount += $raiseAmount;
            }
            $poker->pot_value += $raiseAmount;
        }

        // if turn_amount of player is null then set the player turn_amount = $amount and add the $amount in poker's pot value
        if ($amount > 0 && !$pokerPlayer->turn_amount) {
            $pokerPlayer->turn_amount = $amount;
            $poker->pot_value += $amount;
        }

        // set player turn
        $lastPlayer = $poker->player_turn;
        $nextPlayer = $poker->player_turn < $poker->pokerplayers()->count() ? $poker->player_turn + 1 : 1;
        $poker->player_turn = $nextPlayer;
        $poker->last_player_turn = $lastPlayer;

        // set status
        if ($nextPlayer == 1) {
            $nextStatus = $poker->nextStatus();
            if ($nextStatus) {
                $poker->status = $nextStatus;
            }
        }

        $poker->save();

        $poker = $poker->fresh();

        $this->writeOnFirebase($poker);

        return response()->json($poker);
    }

    private function writeOnFirebase(Poker $poker)
    {
        // update on firebase
        $firebaseDatabase = FirebaseService::getDatabaseInstance();
        if ($firebaseDatabase) {
            $firebaseDatabase->getReference('/fire_app/poker/' . $poker->id)->set($poker);
        }
    }
}
