<?php

namespace Vtlabs\Cardgame\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Cardgame\Models\Order;
use Vtlabs\Cardgame\Models\Product;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Cardgame\Filters\OrderFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Cardgame\Http\Resources\OrderResource;

class OrderController extends Controller
{
    public function index(Request $request)
    {
        return OrderResource::collection(Order::filter($request->all(), OrderFilter::class)->latest()->paginate());
    }

    public function store(Request $request)
    {
        $request->validate([
            'product_id' => 'required|exists:cardgame_products,id',
            'payment_method_slug' => 'required|exists:payment_methods,slug'
        ]);

        $product = Product::find($request->product_id);

        $order = Order::create([
            'product_id' =>  $request->product_id,
            'total' => $product->price,
            'user_id' => Auth::id()
        ]);

        $payment = Auth::user()->createPayment($order, $product->price, $request->payment_method_slug);

        return new OrderResource($order->refresh());
    }
}
