<?php

namespace Vtlabs\Cardgame\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Cardgame\Filters\CashtableFilter;
use Vtlabs\Cardgame\Http\Resources\CashtableResource;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Cardgame\Models\Cashtable;

class CashtableController extends Controller
{
    public function index(Request $request)
    {
        $cashtables = Cashtable::filter($request->all(), CashtableFilter::class)->latest();
        if($request->pagination == '0') {
            $cashtables = $cashtables->get();
        } else {
            $cashtables = $cashtables->paginate();
        }
        return CashtableResource::collection($cashtables);
    }
}
