<?php

namespace Vtlabs\Cardgame\Http\Controllers\Api\Admin;

use Vtlabs\Cardgame\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Cardgame\Http\Resources\Admin\ProductAdminResource;
use Vtlabs\Core\Helpers\CoreHelper;

class ProductController extends Controller
{
    public function index(Request $request)
    {
        $products = Product::ordered();

        if($request->pagination == "0") {
            $products = $products->get();
        } else {
            $products = $products->paginate();
        }

        return ProductAdminResource::collection($products);
    }

    public function show(Product $product)
    {
        return new ProductAdminResource($product);
    }

    public function store(Request $request)
    {
        $request->validate($this->rules());

        CoreHelper::requestMergeJsonField();

        $product = Product::create($request->only($this->fillableFields()));

        return new ProductAdminResource($product);
    }

    public function update(Request $request, Product $product)
    {
        $request->validate($this->rules());

        CoreHelper::requestMergeJsonField();

        $product->fill($request->only($this->fillableFields()));
        $product->save();

        return new ProductAdminResource($product);
    }

    public function destroy(Product $product)
    {
        Gate::authorize('delete');
        
        $product->delete();

        return response()->json([], 204);
    }

    private function rules(): array 
    {
        return [
            'title_translations' => 'required|json|translation',
            'details_translations' => 'required|json|translation',
            'type' => 'required',
            'quantity' => 'required',
            'price' => 'required',
            'currency_type' => 'required',
            'meta' => 'sometimes|json|nullable',
            'image' => 'sometimes|image'
        ];
    }

    private function fillableFields(): array
    {
        return ['title', 'details', 'type', 'quantity', 'price', 'currency_type', 'meta'];
    }
}
