<?php

namespace Vtlabs\Cardgame\Http\Controllers\Api\Admin;

use Vtlabs\Cardgame\Models\Challenge;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Cardgame\Http\Resources\Admin\ChallengeAdminResource;
use Vtlabs\Core\Helpers\CoreHelper;

class ChallengeController extends Controller
{
    public function index(Request $request)
    {
        return ChallengeAdminResource::collection(Challenge::ordered()->paginate());
    }

    public function show(Challenge $challenge)
    {
        return new ChallengeAdminResource($challenge);
    }

    public function store(Request $request)
    {
        $request->validate($this->rules());

        CoreHelper::requestMergeJsonField();

        $challenge = Challenge::create($request->only($this->fillableFields()));

        CoreHelper::requestSaveImage($challenge, 'image');

        return new ChallengeAdminResource($challenge);
    }

    public function update(Request $request, Challenge $challenge)
    {
        $request->validate($this->rules());

        CoreHelper::requestMergeJsonField();

        $challenge
            ->fill($request->only($this->fillableFields()))
            ->save();

        CoreHelper::requestSaveImage($challenge, 'image', true);

        return new ChallengeAdminResource($challenge);
    }

    public function destroy(Challenge $challenge)
    {
        Gate::authorize('delete');

        $challenge->delete();

        return response()->json([], 204);
    }

    private function rules(): array
    {
        return [
            'title_translations' => 'required|json|translation',
            'details_translations' => 'sometimes|json|translation',
            'tasks_count' => 'required',
            'type' => 'required',
            'action' => 'required',
            'sort_order' => 'required|nullable',
            'meta' => 'sometimes|json|nullable',
            'rewards.*' => 'sometimes|array',
            'rewards.*.type' => 'required',
            'rewards.*.quantity' => 'required',
            'rewards.*.product_id' => 'sometimes|nullable',
        ];
    }

    private function fillableFields(): array
    {
        return ['title', 'details', 'tasks_count', 'type', 'action', 'sort_order', 'meta'];
    }
}
