<?php

namespace Vtlabs\Cardgame\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Cardgame\Models\Cashtable;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Cardgame\Http\Resources\Admin\CashtableAdminResource;

class CashtableController extends Controller
{
    public function index(Request $request)
    {
        return CashtableAdminResource::collection(Cashtable::orderBy('amount')->paginate());
    }

    public function show(Cashtable $cashtable)
    {
        return new CashtableAdminResource($cashtable);
    }

    public function store(Request $request)
    {
        $request->validate($this->rules());

        CoreHelper::requestMergeJsonField();

        $cashtable = Cashtable::create($request->only($this->fillableFields()));

        CoreHelper::requestSaveImage($cashtable, 'image');

        return new CashtableAdminResource($cashtable);
    }

    public function update(Request $request, Cashtable $cashtable)
    {
        $request->validate(array_merge($this->rules(), [
            'image' => 'sometimes|image'
        ]));

        CoreHelper::requestMergeJsonField();

        $cashtable->fill($request->only($this->fillableFields()));
        $cashtable->save();

        return new CashtableAdminResource($cashtable);
    }

    public function destroy(Cashtable $cashtable)
    {
        Gate::authorize('delete');
        
        $cashtable->delete();

        return response()->json([], 204);
    }

    private function rules(): array 
    {
        return [
            'reward' => 'required',
            'amount' => 'required',
            'meta' => 'sometimes|json|nullable'
        ];
    }

    private function fillableFields(): array
    {
        return ['reward', 'amount', 'meta'];
    }
}
