<?php

namespace Vtlabs\Cardgame\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Vtlabs\Cardgame\Models\Avatar;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Cardgame\Http\Resources\Admin\AvatarAdminResource;

class AvatarController extends Controller
{
    public function index(Request $request)
    {
        return AvatarAdminResource::collection(Avatar::orderBy('sort_order')->paginate());
    }

    public function show(Avatar $avatar)
    {
        return new AvatarAdminResource($avatar);
    }

    public function store(Request $request)
    {
        $request->validate($this->rules());

        CoreHelper::requestMergeJsonField();

        $avatar = Avatar::create($request->only($this->fillableFields()));

        CoreHelper::requestSaveImage($avatar, 'image');

        return new AvatarAdminResource($avatar);
    }

    public function update(Request $request, Avatar $avatar)
    {
        $request->validate(array_merge($this->rules(), [
            'image' => 'sometimes|image'
        ]));

        CoreHelper::requestMergeJsonField();

        $avatar->fill($request->only($this->fillableFields()));
        $avatar->save();

        CoreHelper::requestSaveImage($avatar, 'image', true);

        return new AvatarAdminResource($avatar);
    }

    public function destroy(Avatar $avatar)
    {
        Gate::authorize('delete');
        
        $avatar->delete();

        return response()->json([], 204);
    }

    private function rules(): array 
    {
        return [
            'image' => 'required|image',
            'sort_order' => 'required',
            'meta' => 'sometimes|json|nullable'
        ];
    }

    private function fillableFields(): array
    {
        return ['sort_order', 'meta'];
    }
}
