<?php
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

use Illuminate\Http\Request;

Route::middleware('api')->prefix('api')->name('api')->namespace('Vtlabs\Cardgame\Http\Controllers\Api')->group(function () {

    // admin api
    Route::namespace('Admin')->name('admin')->prefix('admin/cardgame')->group(function () {
        Route::middleware('auth:api')->group(function () {
            Route::apiResource('avatars', 'AvatarController');
            Route::apiResource('cashtables', 'CashtableController');
            Route::apiResource('products', 'ProductController');
            Route::apiResource('levels', 'LevelController');
            Route::apiResource('challenges', 'ChallengeController');
            Route::get('profiles/leaderboard', 'ProfileController@leaderboard');
        });
    });

    // app/web api
    Route::prefix('cardgame')->group(function () {
        Route::get('avatars', 'AvatarController@index');
        Route::get('levels', 'LevelController@index');
        Route::get('products', 'ProductController@index');
        Route::get('challenges', 'ChallengeController@index');
        
        Route::middleware('auth:api')->group(function () {
            Route::get('profiles', 'ProfileController@showMyProfile');
            Route::post('profiles/referral', 'ProfileController@referral');
            Route::get('profiles/leaderboard', 'ProfileController@leaderboard');
            Route::get('profiles/wallet-stats', 'ProfileController@walletStats');

            Route::get('orders', 'OrderController@index');
            Route::post('orders', 'OrderController@store');

            Route::get('cashtables', 'CashtableController@index');

            
            // rummy
            Route::get('games/find', 'GameController@findGame');
            Route::get('games/play-turn/{game}/{gameplayer}', 'GameController@playTurn');
            Route::get('games/declare/{game}/{gameplayer}', 'GameController@declare');
            Route::get('games/pick-card/{game}/{gameplayer}', 'GameController@pickCard');

            // poker
            Route::post('games/poker/find', 'PokerController@findGame');
            Route::post('games/poker/play-turn/{poker}/{pokerplayer}', 'PokerController@playTurn');
        });
    });
});
