<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGamePokersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cardgame_pokers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->enum('status', ['pending', 'starting', 'started', 'parent', 'flop', 'turn', 'river', 'showdown'])->default('pending');
            $table->string('cards', 170)->default('as,2s,3s,4s,5s,6s,7s,8s,9s,10s,js,qs,ks,ah,2h,3h,4h,5h,6h,7h,8h,9h,10h,jh,qh,kh,ad,2d,3d,4d,5d,6d,7d,8d,9d,10d,jd,qd,kd,ac,2c,3c,4c,5c,6c,7c,8c,9c,10c,jc,qc,kc');
            $table->string('community_cards', 20)->nullable();
            $table->double('max_turn_amount', 8, 2)->nullable();
            $table->double('pot_value', 8, 2)->nullable();
            $table->timestamp('start_at')->nullable();
            $table->timestamp('first_player_request_at')->nullable();
            $table->unsignedTinyInteger('player_turn')->default(0);
            $table->unsignedTinyInteger('last_player_turn')->default(0);
            $table->json('meta')->nullable();            
            $table->timestamps();
        });

        Schema::create('cardgame_pokerplayers', function (Blueprint $table) {
            $table->bigIncrements('id');
            
            $table->enum('status', ['waiting','active', 'fold']);
            $table->enum('last_action', ['call','raise', 'fold', 'check', 'allin'])->nullable();

            $table->double('joining_balance', 8, 2)->nullable();
            $table->double('used_balance', 8, 2)->nullable();

            $table->double('turn_amount', 8, 2)->nullable();
            
            $table->string('cards', 450)->nullable();
            
            $table->unsignedTinyInteger('position')->default(0);
            $table->unsignedTinyInteger('turn_count')->default(0);
            $table->unsignedTinyInteger('empty_turns')->default(0); // no of empty turns 
            
            $table->foreignId('profile_id')->nullable()->constrained('cardgame_profiles')->cascadeOnDelete();
            $table->foreignId('poker_id')->nullable()->constrained('cardgame_pokers')->cascadeOnDelete();
            $table->json('meta')->nullable();            
            $table->timestamps();
        });
    }
}
