<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGamesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cardgame_games', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->enum('status', ['pending', 'starting', 'started', 'tossed', 'toss_arranged', 'toss_unassigned', 'cards_spread', 'turn_setup', 'complete'])->default('pending');
            $table->string('cards', 450)->default('as1,as2,2s1,2s2,3s1,3s2,4s1,4s2,5s1,5s2,6s1,6s2,7s1,7s2,8s1,8s2,9s1,9s2,10s1,10s2,js1,js2,qs1,qs2,ks1,ks2,ah1,ah2,2h1,2h2,3h1,3h2,4h1,4h2,5h1,5h2,6h1,6h2,7h1,7h2,8h1,8h2,9h1,9h2,10h1,10h2,jh1,jh2,qh1,qh2,kh1,kh2,ad1,ad2,2d1,2d2,3d1,3d2,4d1,4d2,5d1,5d2,6d1,6d2,7d1,7d2,8d1,8d2,9d1,9d2,10d1,10d2,jd1,jd2,qd1,qd2,kd1,kd2,ac1,ac2,2c1,2c2,3c1,3c2,4c1,4c2,5c1,5c2,6c1,6c2,7c1,7c2,8c1,8c2,9c1,9c2,10c1,10c2,jc1,jc2,qc1,qc2,kc1,kc2,j11,j12');
            $table->string('open_cards', 450)->nullable();
            $table->char('wildcard', 5)->nullable();
            $table->timestamp('start_at')->nullable();
            $table->timestamp('first_player_request_at')->nullable();
            $table->unsignedTinyInteger('player_turn')->default(0);
            $table->unsignedTinyInteger('last_player_turn')->default(0);
            $table->uuid('next_turn_uuid')->nullable();
            $table->json('meta')->nullable();         
            
            $table->foreignId('cashtable_id')->nullable()->constrained('cardgame_cashtable')->cascadeOnDelete();
            
            $table->timestamps();
        });

        Schema::create('cardgame_gameplayers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->enum('status', ['waiting','active', 'dropped', 'declared']);
            $table->unsignedSmallInteger('points')->default(0);
            
            $table->string('cards', 450)->nullable();
            $table->json('arranged_cards')->nullable();            
            
            $table->unsignedTinyInteger('position')->default(0);
            $table->unsignedTinyInteger('turn_count')->default(0);
            $table->boolean('is_card_picked')->default(false);
            $table->unsignedTinyInteger('empty_turns')->default(0); // no of empty turns 
            
            $table->foreignId('profile_id')->nullable()->constrained('cardgame_profiles')->cascadeOnDelete();
            $table->foreignId('game_id')->nullable()->constrained('cardgame_games')->cascadeOnDelete();
            $table->json('meta')->nullable();            
            $table->timestamps();
        });
    }
}
