<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCardgameOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cardgame_orders', function (Blueprint $table) {
            $table->increments('id');
            $table->json('meta')->nullable();

            $table->double('subtotal', 8,2)->default(0.0);
            $table->double('taxes', 8,2)->default(0.0);
            $table->double('discount', 8,2)->default(0.0);
            $table->double('total', 8,2)->default(0.0);

            // event
            $table->bigInteger('product_id')->unsigned()->nullable();
            $table->foreign('product_id')->references('id')->on('cardgame_products')->onDelete('cascade');
            
            // customer
            $table->integer('user_id')->unsigned()->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->timestamps(); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cardgame_orders', function (Blueprint $table) {
            $table->dropForeign(['product_id']);
            $table->dropForeign(['user_id']);
        });

        Schema::dropIfExists('cardgame_orders');
    }
}
