<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCardgameProfilesTable extends Migration
{
    public function up()
    {
        Schema::create('cardgame_profiles', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('profilecode', 8)->nullable();
            $table->json('meta')->nullable();
            $table->bigInteger('balance')->default(0); // this is a winning balance
            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->bigInteger('level_id')->unsigned()->nullable();
            $table->foreign('level_id')->references('id')->on('cardgame_levels')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cardgame_profiles', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
        });
        Schema::dropIfExists('cardgame_profiles');
    }
}
