<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLevelsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cardgame_levels', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->json('title');
            $table->string('condition_type'); // eg. chips
            $table->string('condition_count'); // eg. x amount of chips
            $table->integer('sort_order')->default(1);
            $table->foreignId('parent_id')->nullable()->constrained('cardgame_levels')->cascadeOnDelete();
            $table->json('meta')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cardgame_levels', function (Blueprint $table) {
            $table->dropForeign(['parent_id']);
        });

        Schema::dropIfExists('cardgame_levels');
    }
}
