<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRewardsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cardgame_rewards', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('type'); // chips, frames
            $table->integer('quantity')->default(1);
            $table->foreignId('product_id')->nullable()->constrained('cardgame_products')->cascadeOnDelete();
            $table->morphs('rewardable');
            $table->json('meta')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cardgame_rewards', function (Blueprint $table) {
            $table->dropForeign(['product_id']);
        });

        Schema::dropIfExists('cardgame_rewards');
    }
}
