<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGameProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cardgame_products', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->json('title')->nullable();
            $table->json('details')->nullable();
            $table->string('type'); // chips,frames
            $table->integer('quantity')->default(1);
            $table->double('price')->default(0.0);
            $table->double('charges')->default(0.0);
            $table->double('taxes')->default(0.0);
            $table->enum('currency_type', ['real', 'chip']);
            $table->json('meta')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cardgame_products');
    }
}
